<?php

namespace Pulse\Cti\Block\Adminhtml;

use Magento\Backend\Block\Template;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Model\Auth\Session;
use Magento\Framework\View\Element\BlockInterface;
use Pulse\Cti\Helper\Data;

class PulseNotification extends Template implements BlockInterface
{

    protected $_template = 'Pulse_Cti::block/pulse_notification.phtml';

    protected $helperData;

    protected $authSession;

    /**
     * @param Context $context
     * @param Data    $helperData
     * @param Session $authSession
     * @param array   $data
     */
    public function __construct(
        Context $context,
        Data $helperData,
        Session $authSession,
        array $data = []
    ) {
        $this->helperData  = $helperData;
        $this->authSession = $authSession;
        parent::__construct($context, $data);
    }


    /**
     * Returns true if Pulse CTI is enabled
     *
     * @return bool
     */
    public function isEnabled(): bool
    {
        return $this->helperData->getFieldConfig('pulse_cti_enabled') ?: false;
    }

    /**
     * Returns true if Pulse CTI Label function is enabled
     *
     * @return bool
     */
    public function isLabelEnabled(): bool
    {
        return $this->helperData->getFieldConfig('pulse_cti_labels') ?: false;
    }

    /**
     * Get Pulse account id
     *
     * @return string
     */
    public function getPulseAccountId(): ?string
    {
        return $this->helperData->getFieldConfig('pulse_cti_account_id');
    }

    /**
     * Get Pulse account name
     *
     * @return string
     */
    public function getPulseAccountName(): ?string
    {
        return $this->helperData->getFieldConfig('pulse_cti_account_name');
    }

    /**
     * Get Pulse cti endpoint url
     *
     * @return string
     */
    public function getHubUrl(): ?string
    {
        $baseUrl = $this->helperData->getFieldConfig('pulse_cti_endpoint');
        return (substr($baseUrl, -1) === '/')
            ? $baseUrl . '.well-known/mercure'
            : $baseUrl . '/.well-known/mercure';
    }

    /**
     * Get Pulse user id
     *
     * @return string
     */
    public function getPulseUserId(): ?string
    {
        return $this->authSession->getUser()->getData('pulse_userid');
    }

    /**
     * Get Pulse user credentials
     *
     * @return string
     */
    public function getPulseCredentials(): ?string
    {
        return $this->authSession->getUser()->getData('pulse_credentials');
    }

    /**
     * Get valid Call labels
     * Static at the moment, but feature versions will support dynamic list.
     *
     * @return array
     */
    public function getCallLabels(): array
    {
        return [
            'Algemeen' => [
                 'Reclame'
                ,'Transporteur'
                ,'Betaalprovider'
                ,'Marketplaces'
                ,'Random'
                ,'Intern'
            ],

            'Aandachtspunt Magazijn' => [
                 'Incompleet Magazijn'
                ,'Foutief product'
                ,'Dubbele doos'
                ,'Ontvangt te veel producten'
                ,'Nalevering onjuist'
                ,'BizBloqs - Niet verzonden, wel voorraad'
                ,'BizBloqs - Manual'
                ,'Demoproduct incompleet/te beschadigd/niet voorradig'
            ],

            'Aandachtspunt Inkoop'=> [
                 'Incompleet Inkoop'
                ,'Defect/Kwaliteit'
                ,'Montage lukt niet'
            ],

            'Regulier Bedenktermijn' => [
                 'Formaat op de website wijkt af'
                ,'Formaat bevalt niet'
                ,'Kwaliteit bevalt niet (geen defecten)'
                ,'Kleur op website wijkt af'
                ,'Kleur bevalt niet'
                ,'Productinformatie op de website wijkt af'
                ,'Annulering zonder specifieke impact reden'
            ],

            'Sorteerfout' => [
                 'DPD - Sorteerfout'
                ,'GLS - Sorteerfout'
                ,'DYN - Sorteerfout'
                ,'E@H - Sorteerfout'
                ,'PNL - Sorteerfout'
                ,'VS - Sorteerfout'
            ],

            'Manco' => [
                'DPD - Manco'
                ,'GLS - Manco'
                ,'DYN - Manco'
                ,'E@H - Manco'
                ,'PNL - Manco'
                ,'VS - Manco'
            ],

            'Fout klant' => [
                 'Klant heeft de verkeerde kleur besteld'
                ,'Klant heeft de verkeerde maat besteld'
                ,'Klant heeft een foutief adres opgevoerd'
                ,'Klant is iets vergeten in de bestelling/Teveel besteld'
                ,'Klant was niet thuis/Retour afzender'
            ],

            'Transport' => [
                'Zending is geleverd, maar niet bij de klant'
            ]
        ];
    }
}
