<?php
namespace Pulse\Cti\Plugin\Block\Adminhtml\User\Edit\Tab;

use Closure;
use Magento\Backend\Model\Auth\Session;
use Magento\Framework\Registry;
use Magento\User\Block\User\Edit\Tab\Main;

class PulseUserFields
{
    /** @var Registry  */
    protected $_coreRegistry;

    public function __construct(Registry $registry)
    {
        $this->_coreRegistry = $registry;
    }

    /**
     * @param Main $subject
     * @param Closure $proceed
     * @return mixed
     */
    public function aroundGetFormHtml(Main $subject, Closure $proceed)
    {
        $form = $subject->getForm();
        if (is_object($form)) {
            $fieldset = $form->addFieldset('admin_user_pulse', ['legend' => __('Pulse User details')]);
            $model = $this->_coreRegistry->registry('permissions_user');

            $fieldset->addField(
                'pulse_userid',
                'text',
                [
                    'name'  => 'pulse_userid',
                    'label' => __('Pulse User ID'),
                    'title' => __('Pulse User ID')
                ]
            );
            $fieldset->addField(
                'pulse_credentials',
                'password',
                [
                    'name'  => 'pulse_credentials',
                    'label' => __('Pulse Credentials'),
                    'title' => __('Pulse Credentials')
                ]
            );

            $form->addValues(
                [
                    'pulse_userid' => $model->getData('pulse_userid'),
                    'pulse_credentials' => $model->getData('pulse_credentials')
                ]
            );

            $subject->setForm($form);
        }

        return $proceed();
    }
}
