<?php

namespace Pulse\Cti\Controller\AdminHtml\Form;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\Auth\Session;
use Magento\Framework\Controller\Result\JsonFactory;
use Magento\Framework\HTTP\Client\Curl;
use Psr\Log\LoggerInterface;
use Pulse\Cti\Helper\Data;

class Label extends Action
{
    protected $resultJsonFactory;
    protected $authSession;
    protected $helperData;
    protected $curl;
    protected $logger;

    public function __construct(
        Context $context,
        JsonFactory $jsonFactory,
        Session $authSession,
        Data $helperData,
        Curl $curl,
        LoggerInterface $logger
    ) {
        parent::__construct($context);
        $this->resultJsonFactory       = $jsonFactory;
        $this->authSession             = $authSession;
        $this->helperData              = $helperData;
        $this->curl                    = $curl;
        $this->logger                  = $logger;
    }//end __construct()

    /**
     * @inheritdoc
     */
    public function execute()
    {
        $resultJson = $this->resultJsonFactory->create();
        $queue = $this->getRequest()->getPost('queue');
        if (!empty($queue) && $queue != 'undefined') {
            $post['queue_id'] = $queue;
        } else {
            return $resultJson->setData(['message' => 'not a queue call']);
        }

        $label = $this->getRequest()->getPost('callLabel');
        $callId = $this->getRequest()->getPost('callId');
        $accountId = $this->helperData->getFieldConfig('pulse_cti_account_id');
        $post['call_label'] = $label;
        $post['call_id'] = $callId;
        $post['account_id'] = $accountId;

        $this->logger->debug("Setting call label $label for call $callId");
        $response = $this->jwtRequest(
            $this->authSession->getUser()->getData('pulse_credentials'),
            $post
        );

        return $resultJson->setData($response);
    }

    public function jwtRequest($token, $post)
    {
        $baseUrl = $this->helperData->getFieldConfig('pulse_cti_endpoint');
        $serviceUrl = (substr($baseUrl, -1) === '/') ? $baseUrl . 'mercure/label' : $baseUrl . '/mercure/label';

        $authorization = "Bearer ".$token; // Prepare the authorisation token
        $post = json_encode($post); // Encode the data array into a JSON string

        $headers = ["Content-Type" => "application/json",
                    "Authorization" => $authorization
        ];
        $this->curl->setHeaders($headers);
        $this->curl->setOption(CURLOPT_FOLLOWLOCATION, true);

        $this->logger->debug("Posting to $serviceUrl: $post");

        $this->curl->post($serviceUrl, $post);

        $returnCode = $this->curl->getStatus();
        $response = $this->curl->getBody();
        $this->logger->debug("Result ($returnCode): $response");

        return json_decode($response, true);
    }
}
